export interface MountInfo {
    src: string;
    dst: string;
    limit: number;
}
export interface SandboxParameter {
    time: number;
    memory: number;
    process: number;
    chroot: string;
    mounts: MountInfo[];
    redirectBeforeChroot: boolean;
    mountProc: boolean;
    executable: string;
    stdin?: string | Number;
    stdout?: string | Number;
    stderr?: string | Number;
    user: string;
    cgroup: string;
    parameters?: string[];
    environments?: string[];
    workingDirectory: string;
    stackSize?: number;
}
export declare enum SandboxStatus {
    Unknown = 0,
    OK = 1,
    TimeLimitExceeded = 2,
    MemoryLimitExceeded = 3,
    RuntimeError = 4,
    Cancelled = 5,
    OutputLimitExceeded = 6,
}
export interface SandboxResult {
    status: SandboxStatus;
    time: number;
    memory: number;
    code: number;
}
