"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const nativeAddon_1 = require("./nativeAddon");
const sandboxProcess_1 = require("./sandboxProcess");
const fs_1 = require("fs");
const randomString = require("randomstring");
const path = require("path");
if (!fs_1.existsSync('/sys/fs/cgroup/memory/memory.memsw.usage_in_bytes')) {
    throw new Error("Your linux kernel doesn't support memory-swap account. Please turn it on following the readme.");
}
async function startSandbox(parameter) {
    return new Promise((res, rej) => {
        const actualParameter = Object.assign({}, parameter);
        actualParameter.cgroup = path.join(actualParameter.cgroup, randomString.generate(9));
        nativeAddon_1.default.StartChild(actualParameter, function (err, result) {
            if (err)
                rej(err);
            else
                res(new sandboxProcess_1.SandboxProcess(result.pid, actualParameter));
        });
    });
}
exports.startSandbox = startSandbox;
;
//# sourceMappingURL=index.js.map